/* Copyright (c) 2010, Carl Burch. License information is located in the
 * com.cburch.logisim.Main source code and at www.cburch.com/logisim/. */

package com.cburch.logisim.std.io;

import java.awt.Color;
import java.awt.Graphics;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;

public class TruLed extends InstanceFactory {
	public TruLed() {
		super("TRULED", Strings.getter("ledComponent"));
		setAttributes(new Attribute[] {
				StdAttr.FACING,
				Io.ATTR_ACTIVE,
				StdAttr.LABEL, Io.ATTR_LABEL_LOC,
				StdAttr.LABEL_FONT, Io.ATTR_LABEL_COLOR
			}, new Object[] {
				Direction.WEST,
				Boolean.TRUE,
				"", Io.LABEL_CENTER,
				StdAttr.DEFAULT_LABEL_FONT, Color.BLACK
			});
		setFacingAttribute(StdAttr.FACING);
		setIconName("led.gif");
		setPorts(new Port[] { new Port(0, 0, Port.INPUT, 24) });
		setInstanceLogger(Logger.class);
	}

	@Override
	public Bounds getOffsetBounds(AttributeSet attrs) {
		Direction facing = attrs.getValue(StdAttr.FACING);
		return Bounds.create(0, -10, 20, 20).rotate(Direction.WEST, facing, 0, 0);
	}

	@Override
	protected void configureNewInstance(Instance instance) {
		instance.addAttributeListener();
		computeTextField(instance);
	}

	@Override
	protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
		if (attr == StdAttr.FACING) {
			instance.recomputeBounds();
			computeTextField(instance);
		} else if (attr == Io.ATTR_LABEL_LOC) {
			computeTextField(instance);
		}
	}

	private void computeTextField(Instance instance) {
		Direction facing = instance.getAttributeValue(StdAttr.FACING);
		Object labelLoc = instance.getAttributeValue(Io.ATTR_LABEL_LOC);

		Bounds bds = instance.getBounds();
		int x = bds.getX() + bds.getWidth() / 2;
		int y = bds.getY() + bds.getHeight() / 2;
		int halign = GraphicsUtil.H_CENTER;
		int valign = GraphicsUtil.V_CENTER;
		if (labelLoc == Direction.NORTH) {
			y = bds.getY() - 2;
			valign = GraphicsUtil.V_BOTTOM;
		} else if (labelLoc == Direction.SOUTH) {
			y = bds.getY() + bds.getHeight() + 2;
			valign = GraphicsUtil.V_TOP;
		} else if (labelLoc == Direction.EAST) {
			x = bds.getX() + bds.getWidth() + 2;
			halign = GraphicsUtil.H_LEFT;
		} else if (labelLoc == Direction.WEST) {
			x = bds.getX() - 2;
			halign = GraphicsUtil.H_RIGHT;
		}
		if (labelLoc == facing) {
			if (labelLoc == Direction.NORTH || labelLoc == Direction.SOUTH) {
				x += 2;
				halign = GraphicsUtil.H_LEFT;
			} else {
				y -= 2;
				valign = GraphicsUtil.V_BOTTOM;
			}
		}

		instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT,
				x, y, halign, valign);
	}

	@Override
	public void propagate(InstanceState state) {
		StateColor data = (StateColor) state.getData();
		if (data == null) {
			System.out.println("creqate new data");
			data = new StateColor(0,0,0);
			state.setData(data);
		} else {
			System.out.println("load color");
			Value[] vals = state.getPort(0).getAll();
		Value red1 = vals[0];
		Value red2 = vals[1];
		Value red4 = vals[2];
		Value red8 = vals[3];
		Value red16 = vals[4];
		Value red32 = vals[5];
		Value red64 = vals[6];
		Value red128 = vals[7];
		Value green1 = vals[8];
		Value green2 = vals[9];
		Value green4 = vals[10];
		Value green8 = vals[11];
		Value green16 = vals[12];
		Value green32 = vals[13];
		Value green64 = vals[14];
		Value green128 = vals[15];
		Value blue1 = vals[16];
		Value blue2 = vals[17];
		Value blue4 = vals[18];
		Value blue8 = vals[19];
		Value blue16 = vals[20];
		Value blue32 = vals[21];
		Value blue64 = vals[22];
		Value blue128 = vals[23];
		int red=0;
		int green=0;
		int blue=0;
		if(red1 == Value.TRUE) red+=1;
		if(red2 == Value.TRUE) red+=2;
		if(red4 == Value.TRUE) red+=4;
		if(red8 == Value.TRUE) red+=8;
		if(red16 == Value.TRUE) red+=16;
		if(red32 == Value.TRUE) red+=32;
		if(red64 == Value.TRUE) red+=64;
		if(red128 == Value.TRUE) red+=128;
		if(green1 == Value.TRUE) green+=1;
		if(green2 == Value.TRUE) green+=2;
		if(green4 == Value.TRUE) green+=4;
		if(green8 == Value.TRUE) green+=8;
		if(green16 == Value.TRUE) green+=16;
		if(green32 == Value.TRUE) green+=32;
		if(green64 == Value.TRUE) green+=64;
		if(green128 == Value.TRUE) green+=128;
		if(blue1 == Value.TRUE) blue+=1;
		if(blue2 == Value.TRUE) blue+=2;
		if(blue4 == Value.TRUE) blue+=4;
		if(blue8 == Value.TRUE) blue+=8;
		if(blue16 == Value.TRUE) blue+=16;
		if(blue32 == Value.TRUE) blue+=32;
		if(blue64 == Value.TRUE) blue+=64;
		if(blue128 == Value.TRUE) blue+=128;
			data.setColor(red,green,blue);
			
			System.out.println("end color");
		}
	}
	
	@Override
	public void paintGhost(InstancePainter painter) {
		Graphics g = painter.getGraphics();
		Bounds bds = painter.getBounds();
		GraphicsUtil.switchToWidth(g, 2);
		g.drawOval(bds.getX() + 1, bds.getY() + 1,
				bds.getWidth() - 2, bds.getHeight() - 2);
	}

	@Override
	public void paintInstance(InstancePainter painter) {
		StateColor data = (StateColor) painter.getData();
		
			System.out.println("precolor");
		Color me = data == null ? Color.BLACK : (Color) data.getColor();;
		Bounds bds = painter.getBounds().expand(-1);

		Graphics g = painter.getGraphics();
		if (painter.getShowState()) {
			g.setColor(me);
			g.fillOval(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
		}
		
			System.out.println("post color");
		g.setColor(Color.BLACK);
		GraphicsUtil.switchToWidth(g, 2);
		g.drawOval(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
		GraphicsUtil.switchToWidth(g, 1);
		g.setColor(painter.getAttributeValue(Io.ATTR_LABEL_COLOR));
		painter.drawLabel();
		painter.drawPorts();
	}

	public static class Logger extends InstanceLogger {
		@Override
		public String getLogName(InstanceState state, Object option) {
			return state.getAttributeValue(StdAttr.LABEL);
		}
	
		@Override
		public Value getLogValue(InstanceState state, Object option) {
			InstanceDataSingleton data = (InstanceDataSingleton) state.getData();
			if (data == null) return Value.FALSE;
			return data.getValue() == Value.TRUE ? Value.TRUE : Value.FALSE; 
		}
	}
	
	private static class StateColor implements InstanceData, Cloneable {
		private int r;
		private int g;
		private int b;
		
		public StateColor(int r, int g, int b) {
			this.r = 0;
			this.g = 0;
			this.b = 0;
		}
		
		@Override
		public Object clone() {
			try {
				StateColor ret = (StateColor) super.clone();
				return ret;
			} catch (CloneNotSupportedException e) {
				return null;
			}
		}
		
		private Color getColor() {
			return new Color(r,g,b);
		}
		
		private void setColor(int r, int g, int b) {
			this.r=r;
			this.g=g;
			this.b=b;
		}
		
	}
}
