/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs316;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class RegisterFile
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final BitWidth WIDTH = BitWidth.create((int)16);
    static final BitWidth DEPTH = BitWidth.create((int)4);
    static final int NUM_REGISTERS = 16;
    static final int CHIP_WIDTH = 160;
    static final int CHIP_DEPTH = 180;
    static final int DIGITS = 4;
    static final int BOX_WIDTH = 38;
    static final int COL_WIDTH = 58;
    static final int BOX_SEP = 10;
    private MyListener myListener = new MyListener();
    static final int P_WDATA = 0;
    static final int P_RDATA1 = 1;
    static final int P_RDATA2 = 2;
    static final int P_WE = 3;
    static final int P_CLK = 4;
    static final int P_WADDR = 5;
    static final int P_RADDR1 = 6;
    static final int P_RADDR2 = 7;
    static final int NUM_PINS = 8;
    static final Value zero = Value.createKnown((BitWidth)WIDTH, (int)0);
    static final Value xxxx = Value.createError((BitWidth)WIDTH);
    static final Value zzzz = Value.createUnknown((BitWidth)WIDTH);

    private RegisterFile(Location loc, AttributeSet attrs) {
        super(loc, attrs, 8);
        int left = -160;
        int right = 0;
        int top = -90;
        int bottom = 90;
        this.setEnd(0, loc.translate(left, -10), WIDTH, 1);
        this.setEnd(1, loc.translate(right, top + 40), WIDTH, 2);
        this.setEnd(2, loc.translate(right, bottom - 40), WIDTH, 2);
        this.setEnd(3, loc.translate(left + 80 - 40, bottom), BitWidth.ONE, 1);
        this.setEnd(4, loc.translate(left, bottom - 10), BitWidth.ONE, 1);
        this.setEnd(5, loc.translate(left + 80 - 10, bottom), DEPTH, 1);
        this.setEnd(6, loc.translate(left + 80 + 30, bottom), DEPTH, 1);
        this.setEnd(7, loc.translate(left + 80 + 50, bottom), DEPTH, 1);
        attrs.addAttributeListener((AttributeListener)this.myListener);
    }

    public Object getFeature(Object key) {
        return key == Pokable.class ? this.myListener : super.getFeature(key);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(CircuitState circuitState) {
        Value v1;
        State state = this.getState(circuitState);
        if (state.tick(this.val(circuitState, 4)) && this.val(circuitState, 3) == Value.TRUE) {
            int a = this.addr(circuitState, 5);
            Value v = this.val(circuitState, 0);
            if (a < 0) {
                state.reset(zzzz);
            } else if (a < 16) {
                state.R[a] = v;
            } else {
                System.err.println("Write address invalid: Please email kwalsh@cs and tell him!\n");
            }
        }
        int a1 = this.addr(circuitState, 6);
        int a2 = this.addr(circuitState, 7);
        if (a1 >= 16 || a2 >= 16) {
            System.err.println("Read address invalid: Please email kwalsh@cs and tell him!\n");
        }
        Value value = a1 < 0 ? zzzz : (v1 = a1 < 16 ? state.R[a1] : xxxx);
        Value v2 = a2 < 0 ? zzzz : (a2 < 16 ? state.R[a2] : xxxx);
        circuitState.setValue(this.loc(1), v1, (Component)this, 9);
        circuitState.setValue(this.loc(2), v2, (Component)this, 9);
    }

    private State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State();
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    public int boxX(int i) {
        if (i < 8) {
            return 37;
        }
        return 105;
    }

    public int boxY(int i) {
        return (i %= 8) * 20;
    }

    public void drawBox(Graphics g, Bounds bds, Color color, int i) {
        g.setColor(color);
        g.drawRect(bds.getX() + this.boxX(i), bds.getY() + this.boxY(i) + 2, 38, 16);
        g.setColor(Color.BLACK);
    }

    public void draw(ComponentDrawContext context) {
        int i;
        context.drawRectangle((Component)this);
        context.drawClock((Component)this, 4, Direction.EAST);
        context.drawPin((Component)this, 5);
        context.drawPin((Component)this, 0);
        context.drawPin((Component)this, 3);
        context.drawPin((Component)this, 6);
        context.drawPin((Component)this, 1);
        context.drawPin((Component)this, 7);
        context.drawPin((Component)this, 2);
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        int left = bds.getX();
        int right = bds.getX() + 160;
        int top = bds.getY();
        int bottom = bds.getY() + 180;
        GraphicsUtil.drawText((Graphics)g, (String)"W", (int)(left + 2), (int)(top + 90 - 10), (int)-1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"A", (int)(right - 2), (int)(top + 40), (int)1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"B", (int)(right - 2), (int)(bottom - 40), (int)1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"WE", (int)(left + 80 - 40), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rW", (int)(left + 80 - 10), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rA", (int)(left + 80 + 30), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rB", (int)(left + 80 + 50), (int)(bottom - 1), (int)0, (int)2);
        for (i = 0; i < 16; ++i) {
            this.drawBox(g, bds, Color.GRAY, i);
        }
        for (i = 0; i < 16; ++i) {
            GraphicsUtil.drawText((Graphics)g, (String)("r" + i), (int)(bds.getX() + this.boxX(i) - 2), (int)(bds.getY() + this.boxY(i) + 10), (int)1, (int)0);
        }
        if (!context.getShowState()) {
            return;
        }
        State state = this.getState(context.getCircuitState());
        for (int i2 = 0; i2 < 16; ++i2) {
            int v = state.R[i2].toIntValue();
            String s = v < 0 ? "?" : StringUtil.toHexString((int)WIDTH.getWidth(), (int)v);
            GraphicsUtil.drawCenteredText((Graphics)g, (String)s, (int)(bds.getX() + this.boxX(i2) + 19), (int)(bds.getY() + this.boxY(i2) + 10));
        }
    }

    private class State
    implements ComponentState,
    Cloneable {
        public Value lastClock = null;
        public Value[] R = new Value[16];

        public State() {
            this.reset(zero);
        }

        public void reset(Value val) {
            for (int i = 0; i < 16; ++i) {
                this.R[i] = val;
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean tick(Value clk) {
            boolean rising = this.lastClock == null || this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            return rising;
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circuitState;
        int idx;
        int idx2;

        PokeCaret(CircuitState circuitState) {
            this.circuitState = circuitState;
            this.idx = -1;
            this.setBounds(RegisterFile.this.getBounds());
        }

        public void draw(Graphics g) {
            if (this.idx < 0) {
                return;
            }
            Bounds bds = RegisterFile.this.getBounds();
            RegisterFile.this.drawBox(g, bds, Color.RED, this.idx);
        }

        public void keyTyped(KeyEvent e) {
            int a2;
            Value val;
            State state = RegisterFile.this.getState(this.circuitState);
            if (this.idx < 0) {
                return;
            }
            int nue = Character.digit(e.getKeyChar(), 16);
            if (nue < 0) {
                return;
            }
            int old = state.R[this.idx].toIntValue();
            if (old < 0) {
                old = 0;
            }
            state.R[this.idx] = val = Value.createKnown((BitWidth)WIDTH, (int)(old * 16 + nue & WIDTH.getMask()));
            int a1 = RegisterFile.this.addr(this.circuitState, 6);
            if (a1 == this.idx) {
                this.circuitState.setValue(RegisterFile.this.loc(1), val, (Component)RegisterFile.this, 1);
            }
            if ((a2 = RegisterFile.this.addr(this.circuitState, 7)) == this.idx) {
                this.circuitState.setValue(RegisterFile.this.loc(2), val, (Component)RegisterFile.this, 1);
            }
        }

        public void stopEditing() {
        }

        public void cancelEditing() {
        }

        public void mousePressed(MouseEvent e) {
            this.idx2 = this.getRIndex(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            System.out.println("dragged: " + e);
        }

        public void mouseReleased(MouseEvent e) {
            int idx3 = this.getRIndex(e.getX(), e.getY());
            if (idx3 < 0 || this.idx2 != idx3) {
                this.idx = -1;
                return;
            }
            this.idx = idx3;
        }

        public void keyPressed(KeyEvent e) {
            if (this.idx < 0) {
                return;
            }
            switch (e.getKeyCode()) {
                case 39: 
                case 40: 
                case 225: 
                case 227: {
                    if (this.idx >= 15) break;
                    ++this.idx;
                    break;
                }
                case 37: 
                case 38: 
                case 224: 
                case 226: {
                    if (this.idx <= 0) break;
                    --this.idx;
                }
            }
        }

        private int getRIndex(int x, int y) {
            Bounds bds = RegisterFile.this.getBounds();
            y -= bds.getY();
            if ((x -= bds.getX()) < RegisterFile.this.boxX(0) - 1 || x > RegisterFile.this.boxX(15) + 38 + 1) {
                return -1;
            }
            if (x > RegisterFile.this.boxX(0) + 38 + 1 && x < RegisterFile.this.boxX(15) - 1) {
                return -1;
            }
            if (y < RegisterFile.this.boxY(0) || y > RegisterFile.this.boxY(15) + 20) {
                return -1;
            }
            int i = y / 20;
            if (x > 80) {
                i += 8;
            }
            if (i < 0 || i >= 16) {
                return -1;
            }
            return i;
        }
    }

    private class MyListener
    implements AttributeListener,
    Pokable {
        private MyListener() {
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        public void attributeValueChanged(AttributeEvent e) {
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            return new PokeCaret(event.getCircuitState());
        }
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "RegisterFile";
        }

        public String getDisplayName() {
            return "Register File";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new RegisterFile(loc, attrs);
        }

        public Bounds getOffsetBounds(AttributeSet arg0) {
            return Bounds.create((int)-160, (int)-90, (int)160, (int)180);
        }
    }
}

