/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs316;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import edu.cornell.cs316.ProgramFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

class Program
extends ManagedComponent {
    static final int NO_OP = 0;
    static final int NUM_ROWS = 5;
    static final int CHIP_WIDTH = 200;
    static final int CHIP_DEPTH = 110;
    public static final ComponentFactory factory = new ProgramFactory("Program", "Program ROM", 200, 110);
    static final BitWidth PC_WIDTH = BitWidth.create((int)16);
    static final BitWidth OP_WIDTH = BitWidth.create((int)16);
    static final int BOX_WIDTH = 145;
    static final int ACOL_WIDTH = 38;
    static final int ARROW_WIDTH = 35;
    protected MyListener myListener;
    static final int P_PC = 0;
    static final int P_OP = 1;
    static final int NUM_PINS = 2;
    static final short[] zero = new short[0];
    Project proj;

    protected Program(Location loc, AttributeSet attrs) {
        super(loc, attrs, 2);
        this.setEnds(loc);
    }

    protected void setEnds(Location loc) {
        int left = -200;
        int right = 0;
        this.setEnd(0, loc.translate(left, 0), PC_WIDTH, 1);
        this.setEnd(1, loc.translate(right, 0), OP_WIDTH, 2);
        this.myListener = new MyListener();
    }

    public Object getFeature(Object key) {
        return key == Pokable.class ? this.myListener : super.getFeature(key);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    Listing getCode() {
        return (Listing)this.getAttributeSet().getValue(ProgramFactory.CODE_ATTR);
    }

    void setProject(Project p) {
        this.proj = p;
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(CircuitState circuitState) {
        State state = this.getState(circuitState);
        state.update(this.val(circuitState, 0));
        circuitState.setValue(this.loc(1), Value.createKnown((BitWidth)OP_WIDTH, (int)state.instr()), (Component)this, 9);
    }

    protected State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State(this.getCode());
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    public void drawBox(Graphics g, Bounds bds, Color color) {
        g.setColor(color);
        g.drawRect(bds.getX() + 35, bds.getY() + 5 + 2, 38, 96);
        g.drawRect(bds.getX() + 35, bds.getY() + 5 + 2, 145, 96);
        g.setColor(Color.BLACK);
    }

    public void drawArrow(Graphics g, Bounds bds, Color color) {
        int left = bds.getX() + 35 - 13;
        int c = bds.getY() + 50 + 5;
        int[] xs = new int[]{left, left + 8, left, left};
        int[] ys = new int[]{c - 5, c, c + 5, c - 5};
        g.setColor(color);
        g.fillPolygon(xs, ys, 4);
        g.setColor(Color.BLACK);
        g.drawPolyline(xs, ys, 4);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this);
        context.drawPin((Component)this, 0, "PC", Direction.EAST);
        context.drawPin((Component)this, 1, "Op", Direction.WEST);
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        this.drawBox(g, bds, Color.GRAY);
        if (context.getShowState()) {
            this.drawState(context);
        }
    }

    public void drawState(ComponentDrawContext context) {
        State state = this.getState(context.getCircuitState());
        if (state.code.data.length == 0) {
            return;
        }
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        this.drawArrow(g, bds, state.badPC() ? Color.YELLOW : Color.BLUE);
        int j = -1;
        for (int i = state.pc - 2; i <= state.pc + 2; ++i) {
            ++j;
            if (state.badPC(i)) continue;
            if (i == state.pc) {
                g.setColor(Color.BLUE);
            }
            GraphicsUtil.drawText((Graphics)g, (String)StringUtil.toHexString((int)16, (int)(i * 2)), (int)(bds.getX() + 35 + 2), (int)(bds.getY() + 20 * j + 10 + 5), (int)-1, (int)0);
            GraphicsUtil.drawText((Graphics)g, (String)state.decode(i), (int)(bds.getX() + 35 + 38 + 2), (int)(bds.getY() + 20 * j + 10 + 5), (int)-1, (int)0);
            if (i != state.pc) continue;
            g.setColor(Color.BLACK);
        }
    }

    class State
    implements ComponentState,
    Cloneable {
        Listing code;
        public int pc;

        public State(Listing code) {
            this.code = code;
            code.setListener(this);
            this.pc = -1;
        }

        public Project getProject() {
            return Program.this.proj;
        }

        public void setProject(Project p) {
            Program.this.proj = p;
        }

        public void codeChanged() {
            if (Program.this.proj != null) {
                Program.this.propagate(Program.this.proj.getCircuitState());
            }
        }

        String decode(int i) {
            return this.code.decode(i);
        }

        String decode() {
            return this.code.decode(this.pc);
        }

        int instr() {
            return this.code.instr(this.pc);
        }

        int opcode() {
            return this.code.opcode(this.pc);
        }

        int arg(int r) {
            return this.code.arg(this.pc, r);
        }

        boolean badPC(int i) {
            return i < 0 || i >= this.code.data.length;
        }

        boolean badPC() {
            return this.badPC(this.pc);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void update(Value pc_in) {
            this.pc = pc_in.toIntValue();
        }
    }

    static class Listing
    implements Cloneable {
        public short[] data;
        public State state;

        public Listing() {
            this.data = zero;
        }

        public void setListener(State state) {
            this.state = state;
        }

        public void load(File file) throws IOException {
            this.data = this.parse(file);
        }

        public void setData(short[] data) {
            this.data = data;
        }

        public State getState() {
            return this.state;
        }

        public Listing(String value) throws IOException {
            ArrayList<String> list = new ArrayList<String>();
            int lineBreak = value.indexOf(10);
            String first = lineBreak < 0 ? value : value.substring(0, lineBreak);
            String rest = lineBreak < 0 ? null : value.substring(lineBreak + 1);
            int lineno = 0;
            while (first.length() > 0) {
                list.add(++lineno + ":" + first);
                if (rest == null) break;
                lineBreak = rest.indexOf(10);
                first = lineBreak < 0 ? rest : rest.substring(0, lineBreak);
                rest = lineBreak < 9 ? null : rest.substring(lineBreak + 1);
            }
            short[] data = new short[list.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = this.encode((String)list.get(i));
            }
            this.data = data;
        }

        public String write() throws IOException {
            StringWriter ret = new StringWriter();
            for (int i = 0; i < this.data.length; ++i) {
                ret.write(this.decode(i) + "\n");
            }
            return ret.toString();
        }

        String decode(int i) {
            if (i < 0 || i >= this.data.length) {
                return "";
            }
            int op = this.opcode(i);
            int rW = this.arg(i, 0);
            int rA = this.arg(i, 1);
            int rB = this.arg(i, 2);
            switch (op) {
                case 0: {
                    return "add r" + rW + ", r" + rA + ", r" + rB;
                }
                case 1: {
                    return "sub r" + rW + ", r" + rA + ", r" + rB;
                }
                case 2: {
                    return "shl r" + rW + ", r" + rA + ", r" + rB;
                }
                case 3: {
                    return "shr r" + rW + ", r" + rA + ", r" + rB;
                }
                case 4: {
                    return "and r" + rW + ", r" + rA + ", r" + rB;
                }
                case 5: {
                    return "or  r" + rW + ", r" + rA + ", r" + rB;
                }
                case 6: {
                    return "not r" + rW + ", r" + rA;
                }
                case 7: {
                    return "xor r" + rW + ", r" + rA + ", r" + rB;
                }
            }
            return "";
        }

        int instr(int i) {
            if (i < 0 || i >= this.data.length) {
                return 0;
            }
            return this.data[i];
        }

        int opcode(int i) {
            return this.instr(i) >> 13 & 7;
        }

        int arg(int i, int r) {
            int s;
            switch (r) {
                case 0: {
                    s = 8;
                    break;
                }
                case 1: {
                    s = 4;
                    break;
                }
                case 2: {
                    s = 0;
                    break;
                }
                default: {
                    return 0;
                }
            }
            return this.instr(i) >> s & 0xF;
        }

        short[] parse(File file) throws IOException {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(file));
            ArrayList<String> lines = new ArrayList<String>();
            int lineno = 0;
            String s = in.readLine();
            while (s != null) {
                ++lineno;
                i = s.indexOf("//");
                if (i != 0) {
                    if (i > 0) {
                        s = s.substring(0, i);
                    }
                    if ((s = s.trim()).length() != 0) {
                        lines.add(lineno + ":" + s);
                    }
                }
                s = in.readLine();
            }
            in.close();
            if (lines.size() == 0) {
                throw new IOException("File was empty, except for comments and blank lines");
            }
            short[] newdata = new short[lines.size()];
            for (i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                newdata[i] = this.encode(line);
            }
            return newdata;
        }

        short encode(String s) throws IOException {
            int lineno = Integer.parseInt(s.substring(0, s.indexOf(58)));
            if ((s = s.substring(s.indexOf(58) + 1).toLowerCase()).regionMatches(0, "add", 0, 3)) {
                return this.encode(0, "add", s, 3, lineno);
            }
            if (s.regionMatches(0, "sub", 0, 3)) {
                return this.encode(1, "sub", s, 3, lineno);
            }
            if (s.regionMatches(0, "shl", 0, 3)) {
                return this.encode(2, "shl", s, 3, lineno);
            }
            if (s.regionMatches(0, "shr", 0, 3)) {
                return this.encode(3, "shr", s, 3, lineno);
            }
            if (s.regionMatches(0, "and", 0, 3)) {
                return this.encode(4, "and", s, 3, lineno);
            }
            if (s.regionMatches(0, "or", 0, 3)) {
                return this.encode(5, "or", s, 3, lineno);
            }
            if (s.regionMatches(0, "not", 0, 3)) {
                return this.encode(6, "not", s, 2, lineno);
            }
            if (s.regionMatches(0, "xor", 0, 3)) {
                return this.encode(7, "xor", s, 3, lineno);
            }
            throw new IOException("Invalid instruction: '" + s + "'");
        }

        short encode(int opcode, String op, String s, int n, int lineno) throws IOException {
            int i = op.length();
            int e = s.length();
            int c1 = s.indexOf(44);
            if (c1 <= 0) {
                throw new IOException("Error at line " + lineno + "\n" + "while reading '" + s + "'.\n" + "Missing ','.");
            }
            int c2 = s.indexOf(44, c1 + 1);
            if (n == 3 && c2 < 0) {
                throw new IOException("Error at line " + lineno + "\n" + "while reading '" + s + "'.\n" + "Missing ','.");
            }
            if (n == 2 && c2 >= 0) {
                throw new IOException("Error at line " + lineno + "\n" + "while reading '" + s + "'.\n" + "Extraneous ','.");
            }
            if (n == 2) {
                c2 = e;
            }
            if (i >= e || !Character.isWhitespace(s.charAt(i))) {
                throw new IOException("Error at line " + lineno + ", column " + (i + 1) + "\n" + "while reading '" + s + "'.\n" + "Expecting whitespace after '" + op + "'.");
            }
            String sW = s.substring(i, c1).trim();
            String sA = s.substring(c1 + 1, c2).trim();
            String sB = n == 3 ? s.substring(c2 + 1, e).trim() : "r0";
            int rW = this.reg(sW, lineno);
            int rA = this.reg(sA, lineno);
            int rB = this.reg(sB, lineno);
            return (short)(opcode << 13 | rW << 8 | rA << 4 | rB << 0);
        }

        int reg(String s, int lineno) throws IOException {
            if (s.length() < 2 || s.charAt(0) != 'r') {
                throw new IOException("Error at line " + lineno + "\n" + "while reading '" + s + "'.\n" + "Expecting register label of the form 'rXX'.");
            }
            try {
                int r = Integer.parseInt(s.substring(1));
                if (r < 0 || r > 16) {
                    throw new Exception();
                }
                return r;
            }
            catch (Exception e) {
                throw new IOException("Error at line " + lineno + "\n" + "while reading '" + s + "'.\n" + "'" + s.substring(1) + "' is not a valid register number.");
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    protected class MyListener
    implements Pokable {
        protected MyListener() {
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            Canvas canvas = event.getCanvas();
            if (canvas != null) {
                ProgramAttributes attrs = (ProgramAttributes)Program.this.getAttributeSet();
                Program.this.setProject(canvas.getProject());
            }
            return null;
        }
    }

    static class ProgramAttributes
    extends AbstractAttributeSet {
        private static List ATTRIBUTES = Arrays.asList(ProgramFactory.CODE_ATTR);
        private static WeakHashMap windowRegistry = new WeakHashMap();
        private Listing contents = new Listing();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ProgramFrame getProgramFrame(Listing value) {
            WeakHashMap weakHashMap = windowRegistry;
            synchronized (weakHashMap) {
                ProgramFrame ret = (ProgramFrame)windowRegistry.get(value);
                if (ret == null) {
                    ret = new ProgramFrame(value);
                    ret.setLocationRelativeTo(null);
                    ret.setLocation(300, 200);
                    windowRegistry.put(value, ret);
                }
                return ret;
            }
        }

        ProgramAttributes() {
        }

        protected void copyInto(AbstractAttributeSet dest) {
            ProgramAttributes d = (ProgramAttributes)dest;
            d.contents = (Listing)this.contents.clone();
        }

        public List getAttributes() {
            return ATTRIBUTES;
        }

        public Object getValue(Attribute attr) {
            if (attr == ProgramFactory.CODE_ATTR) {
                return this.contents;
            }
            return null;
        }

        public void setValue(Attribute attr, Object value) {
            if (attr == ProgramFactory.CODE_ATTR) {
                this.contents = (Listing)value;
            }
            this.fireAttributeValueChanged(attr, value);
        }
    }

    protected static class ProgramFactory
    extends AbstractComponentFactory {
        int W;
        int D;
        String N;
        String DN;
        public static Attribute CODE_ATTR = new ContentsAttribute();

        protected ProgramFactory(String n, String dn, int w, int d) {
            this.N = n;
            this.DN = dn;
            this.W = w;
            this.D = d;
        }

        public String getName() {
            return this.N;
        }

        public String getDisplayName() {
            return this.DN;
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Program(loc, attrs);
        }

        public Bounds getOffsetBounds(AttributeSet arg0) {
            return Bounds.create((int)(-1 * this.W), (int)(-1 * this.D / 2), (int)this.W, (int)this.D);
        }

        public AttributeSet createAttributeSet() {
            return new ProgramAttributes();
        }

        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            Graphics g = context.getGraphics();
            Font old = g.getFont();
            g.setFont(old.deriveFont(9.0f));
            GraphicsUtil.drawCenteredText((Graphics)g, (String)"ASM", (int)(x + 10), (int)(y + 9));
            g.setFont(old);
            g.drawRect(x, y + 4, 19, 12);
            for (int dx = 2; dx < 20; dx += 5) {
                g.drawLine(x + dx, y + 2, x + dx, y + 4);
                g.drawLine(x + dx, y + 16, x + dx, y + 18);
            }
        }

        private static class ContentsCell
        extends JLabel
        implements MouseListener {
            Listing code;

            ContentsCell(Listing code) {
                super("(click here to edit)");
                this.code = code;
                this.addMouseListener(this);
            }

            public void mouseClicked(MouseEvent e) {
                if (this.code == null) {
                    return;
                }
                ProgramFrame frame = ProgramAttributes.getProgramFrame(this.code);
                frame.setVisible(true);
                frame.toFront();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        }

        private static class ContentsAttribute
        extends Attribute {
            public ContentsAttribute() {
                super("contents", new StringGetter(){

                    public String get() {
                        return "Program Listing";
                    }
                });
            }

            public java.awt.Component getCellEditor(Window source, Object value) {
                if (source instanceof Frame) {
                    Project proj = ((Frame)source).getProject();
                    Listing code = (Listing)value;
                    State state = code.getState();
                    if (state != null) {
                        state.setProject(proj);
                    }
                }
                ContentsCell cell = new ContentsCell((Listing)value);
                cell.mouseClicked(null);
                return cell;
            }

            public String toDisplayString(Object value) {
                return "(click to edit)";
            }

            public String toStandardString(Object value) {
                try {
                    return ((Listing)value).write();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "The contents of the Program chip could not be written: " + e.getMessage(), "Error saving cs316 program.", 0);
                    return "";
                }
            }

            public Object parse(String value) {
                try {
                    return new Listing(value);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "The contents of the Program chip could not be read: " + e.getMessage(), "Error loading cs316 program.", 0);
                    return new Listing();
                }
            }
        }
    }
}

