/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs316;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import edu.cornell.cs316.Program;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class AutoProgram
extends Program {
    public static final ComponentFactory factory = new AutoProgramFactory("AutoProgram", "Auto-Incrementing Program ROM", 200, 130);
    static final BitWidth CLK_WIDTH = BitWidth.ONE;
    static final int PCLABEL_WIDTH = 60;
    static final int P_CLK = 0;

    protected AutoProgram(Location loc, AttributeSet attrs) {
        super(loc, attrs);
    }

    protected void setEnds(Location loc) {
        int left = -200;
        int right = 0;
        this.setEnd(0, loc.translate(left, 50), CLK_WIDTH, 1);
        this.setEnd(1, loc.translate(right, 0), OP_WIDTH, 2);
        this.myListener = new MyAutoListener();
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    protected Program.State getState(CircuitState circuitState) {
        Program.State state = (Program.State)circuitState.getData((Component)this);
        if (state == null) {
            state = new AutoState(this.getCode());
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    public void drawBox2(Graphics g, Bounds bds, Color color) {
        g.setColor(color);
        g.drawRect(bds.getX() + 60, bds.getY() + 100 + 5 + 1, 38, 16);
        g.setColor(Color.BLACK);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this);
        context.drawClock((Component)this, 0, Direction.EAST);
        context.drawPin((Component)this, 1, "Op", Direction.WEST);
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        this.drawBox(g, bds, Color.GRAY);
        this.drawBox2(g, bds, Color.GRAY);
        int left = bds.getX();
        int bottom = bds.getY() + 110 + 20;
        GraphicsUtil.drawText((Graphics)g, (String)"PC:", (int)(left + 60 - 2), (int)(bottom - 10 - 5 - 1), (int)1, (int)0);
        if (context.getShowState()) {
            Program.State state = this.getState(context.getCircuitState());
            if (state.code.data.length == 0) {
                return;
            }
            String s = state.badPC() ? "????" : StringUtil.toHexString((int)16, (int)(state.pc * 2));
            GraphicsUtil.drawText((Graphics)g, (String)s, (int)(left + 60 + 19), (int)(bottom - 10 - 5 - 1), (int)0, (int)0);
            this.drawState(context);
        }
    }

    class AutoState
    extends Program.State
    implements Cloneable {
        public Value lastClock;

        public AutoState(Program.Listing code) {
            super(AutoProgram.this, code);
            this.lastClock = null;
            this.pc = 0;
        }

        public void codeChanged() {
            this.pc = 0;
            super.codeChanged();
        }

        public void update(Value clk) {
            boolean rising = this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            if (rising && ++this.pc >= this.code.data.length) {
                this.pc = 0;
            }
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circuitState;
        boolean edit_pc = false;
        boolean edit_pc_maybe = false;

        PokeCaret(CircuitState circuitState) {
            this.circuitState = circuitState;
            this.setBounds(AutoProgram.this.getBounds());
        }

        public void draw(Graphics g) {
            Bounds bds = AutoProgram.this.getBounds();
            if (this.edit_pc) {
                AutoProgram.this.drawBox2(g, bds, Color.RED);
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void stopEditing() {
        }

        public void cancelEditing() {
        }

        public void mousePressed(MouseEvent e) {
            Bounds bds = AutoProgram.this.getBounds();
            int x = e.getX() - bds.getX();
            int y = e.getY() - bds.getY();
            if (x >= 58 && x <= 100 && y >= 99 && y <= 119) {
                this.edit_pc_maybe = true;
            } else {
                this.edit_pc_maybe = false;
                this.edit_pc = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            Bounds bds = AutoProgram.this.getBounds();
            int x = e.getX() - bds.getX();
            int y = e.getY() - bds.getY();
            if (this.edit_pc_maybe && x >= 58 && x <= 100 && y >= 99 && y <= 119) {
                this.edit_pc = true;
            }
        }

        public void keyPressed(KeyEvent e) {
            if (!this.edit_pc) {
                return;
            }
            Program.State state = AutoProgram.this.getState(this.circuitState);
            if (state.code.data.length <= 1) {
                return;
            }
            switch (e.getKeyCode()) {
                case 37: 
                case 38: 
                case 224: 
                case 226: {
                    if (--state.pc < 0) {
                        state.pc = state.code.data.length - 1;
                    }
                    AutoProgram.this.propagate(this.circuitState);
                    break;
                }
                case 39: 
                case 40: 
                case 225: 
                case 227: {
                    if (++state.pc >= state.code.data.length) {
                        state.pc = 0;
                    }
                    AutoProgram.this.propagate(this.circuitState);
                }
            }
        }
    }

    protected class MyAutoListener
    extends Program.MyListener {
        protected MyAutoListener() {
            super(AutoProgram.this);
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            super.getPokeCaret(event);
            return new PokeCaret(event.getCircuitState());
        }
    }

    protected static class AutoProgramFactory
    extends Program.ProgramFactory {
        protected AutoProgramFactory(String n, String dn, int w, int d) {
            super(n, dn, w, d);
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new AutoProgram(loc, attrs);
        }
    }
}

