/*
 * Decompiled with CFR 0.152.
 */
package immibis.buzzer;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JOptionPane;

public class BuzzerFactory
extends InstanceFactory {
    public static final Attribute FREQ_ATTR = Attributes.forIntegerRange((String)"Frequency", (int)100, (int)5000);

    public BuzzerFactory() {
        super("Simple buzzer");
        this.setPorts(new Port[]{new Port(0, 0, "input", 1), new Port(40, 0, "input", 1)});
        this.setAttributes(new Attribute[]{FREQ_ATTR}, new Object[]{new Integer(500)});
        this.setOffsetBounds(Bounds.create((int)0, (int)-20, (int)40, (int)40));
    }

    public void propagate(InstanceState state) {
        int freq;
        Data d = (Data)state.getData();
        if (d == null) {
            d = new Data(false);
            state.setData((InstanceData)d);
        }
        boolean bl = d.is_on = state.getPort(0) == Value.TRUE;
        if (d.is_on) {
            d.still_alive = true;
        }
        if ((freq = ((Integer)state.getAttributeValue(FREQ_ATTR)).intValue()) != d.freq) {
            d.freq = freq;
            d.freq_changed = true;
        }
        if (!d.thread.isAlive() && d.is_on) {
            d.StartThread();
        }
    }

    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds b = painter.getBounds();
        int x = b.getX();
        int y = b.getY();
        g.setColor(Color.BLACK);
        for (int k = 0; k <= 20; k += 5) {
            g.drawOval(x + 20 - k, y + 20 - k, k * 2, k * 2);
        }
        painter.drawPort(0);
        painter.drawPort(1);
        Data d = (Data)painter.getData();
        if (d != null && d.is_on) {
            d.still_alive = true;
            if (!d.thread.isAlive()) {
                d.StartThread();
            }
        }
    }

    public void paintGhost(InstancePainter painter) {
        Bounds b = painter.getBounds();
        Graphics g = painter.getGraphics();
        g.setColor(Color.GRAY);
        g.drawOval(b.getX(), b.getY(), 40, 40);
    }

    private static class Data
    implements InstanceData {
        public volatile boolean is_on = false;
        public volatile int freq = 500;
        public volatile boolean freq_changed = true;
        public volatile boolean still_alive = true;
        public Thread thread;

        public void StartThread() {
            this.thread = new Thread(new Runnable(){

                public void run() {
                    SourceDataLine line = null;
                    AudioFormat format = new AudioFormat(11025.0f, 8, 1, true, false);
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    try {
                        line = (SourceDataLine)AudioSystem.getLine(info);
                        line.open(format, 11025);
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        JOptionPane.showMessageDialog(null, sw.getBuffer().toString(), "Could not initialise audio", 0);
                        return;
                    }
                    line.start();
                    byte[] audioData = new byte[1102];
                    Data.this.freq_changed = true;
                    int i = 0;
                    while (true) {
                        if (Data.this.freq_changed) {
                            double step;
                            Data.this.freq_changed = false;
                            double n = step = 11025.0 / (double)Data.this.freq;
                            int val = 127;
                            for (int k = 0; k < audioData.length; ++k) {
                                if ((n -= 1.0) < 0.0) {
                                    n += step;
                                    val = (byte)(-val);
                                }
                                audioData[k] = val;
                            }
                        }
                        if (Data.this.is_on) {
                            line.write(audioData, 0, audioData.length);
                        }
                        try {
                            Thread.sleep(99L);
                        }
                        catch (Exception e) {
                            break;
                        }
                        if (++i != 10) continue;
                        if (!Data.this.still_alive) break;
                        Data.this.still_alive = false;
                        i = 0;
                    }
                    line.stop();
                    line.close();
                }
            });
            this.thread.start();
        }

        public Data(boolean b) {
            this.is_on = b;
            this.StartThread();
        }

        public Object clone() {
            return new Data(this.is_on);
        }
    }
}

