/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs316;

import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.WindowMenuItemManager;
import edu.cornell.cs316.Program;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ProgramFrame
extends JFrame {
    private WindowMenuManager windowManager = new WindowMenuManager();
    private MyListener myListener = new MyListener();
    private Program.Listing code;
    private ListingModel model;
    private JTable listing;
    private JButton load = new JButton();
    private JButton close = new JButton();

    public ProgramFrame(Program.Listing code) {
        this.setDefaultCloseOperation(1);
        this.code = code;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.load);
        buttonPanel.add(this.close);
        this.load.addActionListener(this.myListener);
        this.close.addActionListener(this.myListener);
        this.setTitle("Program Listing");
        this.load.setText("Load Program...");
        this.close.setText("Close Window");
        this.model = new ListingModel();
        this.listing = new JTable(this.model);
        this.listing.setShowHorizontalLines(false);
        this.listing.setShowVerticalLines(true);
        JScrollPane scroll = new JScrollPane(this.listing, 22, 31);
        scroll.setPreferredSize(new Dimension(200, 300));
        Container contents = this.getContentPane();
        contents.add((Component)scroll, "Center");
        contents.add((Component)buttonPanel, "South");
        this.pack();
    }

    public void setVisible(boolean value) {
        if (value && !this.isVisible()) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    private class ListingModel
    extends AbstractTableModel {
        private ListingModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ((ProgramFrame)ProgramFrame.this).code.data.length;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return StringUtil.toHexString((int)16, (int)(row * 2));
            }
            return ProgramFrame.this.code.decode(row);
        }

        public void fireChanged() {
            this.fireTableStructureChanged();
        }

        public String getColumnName(int col) {
            return col == 0 ? "Address" : "Code";
        }
    }

    private class MyListener
    implements ActionListener {
        private File lastFile = null;

        private MyListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == ProgramFrame.this.load) {
                JFileChooser chooser = new JFileChooser();
                if (this.lastFile != null) {
                    chooser.setSelectedFile(this.lastFile);
                }
                chooser.setDialogTitle("Load Program");
                int choice = chooser.showOpenDialog(ProgramFrame.this);
                if (choice == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        short[] old = ((ProgramFrame)ProgramFrame.this).code.data;
                        ProgramFrame.this.code.load(f);
                        short[] data = ((ProgramFrame)ProgramFrame.this).code.data;
                        Program.State state = ProgramFrame.this.code.getState();
                        if (state != null) {
                            state.codeChanged();
                            Project proj = state.getProject();
                            if (proj != null) {
                                proj.doAction((Action)new Change(old, data));
                            }
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(ProgramFrame.this, e.getMessage(), "Error loading cs316 program", 0);
                    }
                }
            } else if (src == ProgramFrame.this.close) {
                WindowEvent e = new WindowEvent(ProgramFrame.this, 201);
                ProgramFrame.this.processWindowEvent(e);
            }
        }
    }

    private class Change
    extends Action {
        short[] old;
        short[] data;
        File file;
        boolean completed = false;

        Change(short[] old, short[] data) {
            this.old = old;
            this.data = data;
        }

        public String getName() {
            return "Load Program Listing";
        }

        public void doIt(Project proj) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            ProgramFrame.this.code.setData(this.data);
            Program.State state = ProgramFrame.this.code.getState();
            if (state != null) {
                state.codeChanged();
            }
            ProgramFrame.this.model.fireChanged();
        }

        public void undo(Project proj) {
            if (!this.completed) {
                return;
            }
            this.completed = false;
            ProgramFrame.this.code.setData(this.old);
            Program.State state = ProgramFrame.this.code.getState();
            if (state != null) {
                state.codeChanged();
            }
            ProgramFrame.this.model.fireChanged();
        }
    }

    private class WindowMenuManager
    extends WindowMenuItemManager {
        WindowMenuManager() {
            super("Program Listing", false);
        }

        public JFrame getJFrame(boolean create) {
            return ProgramFrame.this;
        }
    }
}

